<?php
/**
 * Section Archive
 *
 * @package Eduma
 */

thim_customizer()->add_section(
	array(
		'id'       => 'portfolio_archive',
		'panel'    => 'portfolio',
		'title'    => esc_html__( 'Archive Pages', 'eduma' ),
		'priority' => 10,
	)
);

thim_customizer()->add_field(
	array(
		'id'       => 'thim_portfolio_cate_layout',
		'type'     => 'radio-image',
		'label'    => esc_html__( 'Archive Layouts', 'eduma' ),
		'tooltip'  => esc_html__( 'Allows you to choose a layout for all portfolio archive pages.', 'eduma' ),
		'section'  => 'portfolio_archive',
		'priority' => 12,
		'default'  => 'sidebar-right',
		'choices'  => array(
			'sidebar-left'  => THIM_URI . 'images/layout/sidebar-left.jpg',
			'full-content'    => THIM_URI . 'images/layout/body-full.jpg',
			'sidebar-right' => THIM_URI . 'images/layout/sidebar-right.jpg',
		),
		'wrapper_attrs' => array(
			'class' => '{default_class} thim-col-3'
		)
	)
);
thim_customizer()->add_field(
	array(
		'id'       => 'thim_portfolio_item_size',
		'type'     => 'select',
		'label'    => esc_html__( 'Select a item size', 'eduma' ),
 		'section'  => 'portfolio_archive',
		'priority' => 15,
		'multiple' => 0,
		'default'  => 'same',
		'choices'  => array(
			'multigrid' => esc_html__( 'Multigrid', 'eduma' ),
			'masonry'   => esc_html__( 'Masonry', 'eduma' ),
			'same'      => esc_html__( 'Same size', 'eduma' ),
 		),
	)
);
// Enable or disable breadcrumbs
thim_customizer()->add_field(
	array(
		'id'       => 'thim_portfolio_cate_hide_breadcrumbs',
		'type'     => 'switch',
		'label'    => esc_html__( 'Hide Breadcrumbs?', 'eduma' ),
		'tooltip'  => esc_html__( 'Check this box to hide/show breadcrumbs.', 'eduma' ),
		'section'  => 'portfolio_archive',
		'default'  => false,
		'priority' => 15,
		'choices'  => array(
			true  => esc_html__( 'On', 'eduma' ),
			false => esc_html__( 'Off', 'eduma' ),
		),
	)
);

// Enable or disable title
thim_customizer()->add_field(
	array(
		'id'       => 'thim_portfolio_cate_hide_title',
		'type'     => 'switch',
		'label'    => esc_html__( 'Hide Title', 'eduma' ),
		'tooltip'  => esc_html__( 'Check this box to hide/show title.', 'eduma' ),
		'section'  => 'portfolio_archive',
		'default'  => false,
		'priority' => 18,
		'choices'  => array(
			true  => esc_html__( 'On', 'eduma' ),
			false => esc_html__( 'Off', 'eduma' ),
		),
	)
);

thim_customizer()->add_field(
	array(
		'type'     => 'text',
		'id'       => 'thim_portfolio_cate_sub_title',
		'label'    => esc_html__( 'Sub Heading', 'eduma' ),
		'tooltip'  => esc_html__( 'Allows you can setup sub heading.', 'eduma' ),
		'section'  => 'portfolio_archive',
		'priority' => 20,
	)
);

thim_customizer()->add_field(
	array(
		'type'      => 'image',
		'id'        => 'thim_portfolio_cate_top_image',
		'label'     => esc_html__( 'Top Image', 'eduma' ),
		'priority'  => 30,
		'transport' => 'postMessage',
		'section'  => 'portfolio_archive',
		'default'     => THIM_URI . "images/bg-page.jpg",
	)
);

// Page Title Background Color
thim_customizer()->add_field(
	array(
		'id'          => 'thim_portfolio_cate_bg_color',
		'type'        => 'color',
		'label'       => esc_html__( 'Background Color', 'eduma' ),
		'tooltip'     => esc_html__( 'If you do not use background image, then can use background color for page title on heading top. ', 'eduma' ),
		'section'     => 'portfolio_archive',
		'default'     => 'rgba(0,0,0,0.5)',
		'priority'    => 35,
		'choices' => array ('alpha'     => true),
		'transport' => 'postMessage',
		'js_vars'   => array(
			array(
				'choice'   => 'color',
				'element'  => '.top_site_main>.overlay-top-header',
				'property' => 'background',
			)
		)
	)
);

thim_customizer()->add_field(
	array(
		'id'          => 'thim_portfolio_cate_title_color',
		'type'        => 'color',
		'label'       => esc_html__( 'Title Color', 'eduma' ),
		'tooltip'     => esc_html__( 'Allows you can select a color make text color for title.', 'eduma' ),
		'section'     => 'portfolio_archive',
		'default'     => '#ffffff',
		'priority'    => 40,
		'choices' => array ('alpha'     => true),
		'transport' => 'postMessage',
		'js_vars'   => array(
			array(
				'choice'   => 'color',
				'element'  => '.top_site_main h1, .top_site_main h2',
				'property' => 'color',
			)
		)
	)
);

thim_customizer()->add_field(
	array(
		'id'          => 'thim_portfolio_cate_sub_title_color',
		'type'        => 'color',
		'label'       => esc_html__( 'Sub Title Color', 'eduma' ),
		'tooltip'     => esc_html__( 'Allows you can select a color make sub title color page title.', 'eduma' ),
		'section'     => 'portfolio_archive',
		'default'     => '#999',
		'priority'    => 45,
		'choices' => array ('alpha'     => true),
		'transport' => 'postMessage',
		'js_vars'   => array(
			array(
				'choice'   => 'color',
				'element'  => '.top_site_main .banner-description',
				'property' => 'color',
			)
		)
	)
);

thim_customizer()->add_field(
	array(
		'type'     => 'select',
		'id'       => 'thim_portfolio_cate_grid_column',
		'label'    => esc_html__( 'Grid Columns', 'eduma' ),
		'tooltip'  => esc_html__( 'Choose the number of columns.', 'eduma' ),
		'default'  => '3',
		'priority' => 50,
		'multiple' => 0,
		'section'  => 'portfolio_archive',
		'choices'  => array(
			'2' => esc_html__( '2', 'eduma' ),
			'3' => esc_html__( '3', 'eduma' ),
			'4' => esc_html__( '4', 'eduma' ),
		),
	)
);

thim_customizer()->add_field(
	array(
		'type'     => 'select',
		'id'       => 'thim_portfolio_cate_style_chosen',
		'label'    => esc_html__( 'Hover Effect Style', 'eduma' ),
		'tooltip'  => esc_html__( 'Allows select hover effect style which you want to using.', 'eduma' ),
		'priority' => 55,
		'multiple' => 0,
		'default'  => 'style01',
		'section'  => 'portfolio_archive',
		'choices'  => array(
			'style01' => esc_html__( 'Caption Hover Effects 01', 'eduma' ),
			'style02' => esc_html__( 'Caption Hover Effects 02', 'eduma' ),
			'style03' => esc_html__( 'Caption Hover Effects 03', 'eduma' ),
			'style04' => esc_html__( 'Caption Hover Effects 04', 'eduma' ),
			'style05' => esc_html__( 'Caption Hover Effects 05', 'eduma' ),
			'style06' => esc_html__( 'Caption Hover Effects 06', 'eduma' ),
			'style07' => esc_html__( 'Caption Hover Effects 07', 'eduma' ),
			'style08' => esc_html__( 'Caption Hover Effects 08', 'eduma' ),
			'style09' => esc_html__( 'Caption Hover Effects 09', 'eduma' ),
			'style10' => esc_html__( 'Caption Hover Effects 10', 'eduma' )
		),
	)
);